<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models;

use stdClass;

/**
 * Any additional payment instructions to be consider during payment processing. This processing
 * instruction is applicable for Capturing an order or Authorizing an Order.
 */
class PaymentInstruction implements \JsonSerializable
{
    /**
     * @var PlatformFee[]|null
     */
    private $platformFees;

    /**
     * @var string|null
     */
    private $disbursementMode = DisbursementMode::INSTANT;

    /**
     * @var string|null
     */
    private $payeePricingTierId;

    /**
     * @var string|null
     */
    private $payeeReceivableFxRateId;

    /**
     * Returns Platform Fees.
     * An array of various fees, commissions, tips, or donations. This field is only applicable to
     * merchants that been enabled for PayPal Complete Payments Platform for Marketplaces and Platforms
     * capability.
     *
     * @return PlatformFee[]|null
     */
    public function getPlatformFees(): ?array
    {
        return $this->platformFees;
    }

    /**
     * Sets Platform Fees.
     * An array of various fees, commissions, tips, or donations. This field is only applicable to
     * merchants that been enabled for PayPal Complete Payments Platform for Marketplaces and Platforms
     * capability.
     *
     * @maps platform_fees
     *
     * @param PlatformFee[]|null $platformFees
     */
    public function setPlatformFees(?array $platformFees): void
    {
        $this->platformFees = $platformFees;
    }

    /**
     * Returns Disbursement Mode.
     * The funds that are held on behalf of the merchant.
     */
    public function getDisbursementMode(): ?string
    {
        return $this->disbursementMode;
    }

    /**
     * Sets Disbursement Mode.
     * The funds that are held on behalf of the merchant.
     *
     * @maps disbursement_mode
     */
    public function setDisbursementMode(?string $disbursementMode): void
    {
        $this->disbursementMode = $disbursementMode;
    }

    /**
     * Returns Payee Pricing Tier Id.
     * This field is only enabled for selected merchants/partners to use and provides the ability to
     * trigger a specific pricing rate/plan for a payment transaction. The list of eligible
     * 'payee_pricing_tier_id' would be provided to you by your Account Manager. Specifying values other
     * than the one provided to you by your account manager would result in an error.
     */
    public function getPayeePricingTierId(): ?string
    {
        return $this->payeePricingTierId;
    }

    /**
     * Sets Payee Pricing Tier Id.
     * This field is only enabled for selected merchants/partners to use and provides the ability to
     * trigger a specific pricing rate/plan for a payment transaction. The list of eligible
     * 'payee_pricing_tier_id' would be provided to you by your Account Manager. Specifying values other
     * than the one provided to you by your account manager would result in an error.
     *
     * @maps payee_pricing_tier_id
     */
    public function setPayeePricingTierId(?string $payeePricingTierId): void
    {
        $this->payeePricingTierId = $payeePricingTierId;
    }

    /**
     * Returns Payee Receivable Fx Rate Id.
     * FX identifier generated returned by PayPal to be used for payment processing in order to honor FX
     * rate (for eligible integrations) to be used when amount is settled/received into the payee account.
     */
    public function getPayeeReceivableFxRateId(): ?string
    {
        return $this->payeeReceivableFxRateId;
    }

    /**
     * Sets Payee Receivable Fx Rate Id.
     * FX identifier generated returned by PayPal to be used for payment processing in order to honor FX
     * rate (for eligible integrations) to be used when amount is settled/received into the payee account.
     *
     * @maps payee_receivable_fx_rate_id
     */
    public function setPayeeReceivableFxRateId(?string $payeeReceivableFxRateId): void
    {
        $this->payeeReceivableFxRateId = $payeeReceivableFxRateId;
    }

    /**
     * Encode this object to JSON
     *
     * @param bool $asArrayWhenEmpty Whether to serialize this model as an array whenever no fields
     *        are set. (default: false)
     *
     * @return array|stdClass
     */
    #[\ReturnTypeWillChange] // @phan-suppress-current-line PhanUndeclaredClassAttribute for (php < 8.1)
    public function jsonSerialize(bool $asArrayWhenEmpty = false)
    {
        $json = [];
        if (isset($this->platformFees)) {
            $json['platform_fees']               = $this->platformFees;
        }
        if (isset($this->disbursementMode)) {
            $json['disbursement_mode']           = DisbursementMode::checkValue($this->disbursementMode);
        }
        if (isset($this->payeePricingTierId)) {
            $json['payee_pricing_tier_id']       = $this->payeePricingTierId;
        }
        if (isset($this->payeeReceivableFxRateId)) {
            $json['payee_receivable_fx_rate_id'] = $this->payeeReceivableFxRateId;
        }

        return (!$asArrayWhenEmpty && empty($json)) ? new stdClass() : $json;
    }
}
