<?php

declare(strict_types=1);

/*
 * PaypalServerSdkLib
 *
 * This file was automatically generated by APIMATIC v3.0 ( https://www.apimatic.io ).
 */

namespace PaypalServerSdkLib\Models\Builders;

use Core\Utils\CoreHelper;
use PaypalServerSdkLib\Models\ConfirmOrderRequest;
use PaypalServerSdkLib\Models\OrderConfirmApplicationContext;
use PaypalServerSdkLib\Models\PaymentSource;

/**
 * Builder for model ConfirmOrderRequest
 *
 * @see ConfirmOrderRequest
 */
class ConfirmOrderRequestBuilder
{
    /**
     * @var ConfirmOrderRequest
     */
    private $instance;

    private function __construct(ConfirmOrderRequest $instance)
    {
        $this->instance = $instance;
    }

    /**
     * Initializes a new confirm order request Builder object.
     */
    public static function init(PaymentSource $paymentSource): self
    {
        return new self(new ConfirmOrderRequest($paymentSource));
    }

    /**
     * Sets processing instruction field.
     */
    public function processingInstruction($value): self
    {
        $this->instance->setProcessingInstruction($value);
        return $this;
    }

    /**
     * Sets application context field.
     */
    public function applicationContext(?OrderConfirmApplicationContext $value): self
    {
        $this->instance->setApplicationContext($value);
        return $this;
    }

    /**
     * Initializes a new confirm order request object.
     */
    public function build(): ConfirmOrderRequest
    {
        return CoreHelper::clone($this->instance);
    }
}
